; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;
; ** 28-Apr-04 LeeH; added support for localized 'wdw' file access messages.
; 01-Oct-03 Mauro Sist globalized
; ** 29-Sep-02 NEHolt adjusted for calling from either VIA-WD Add-on or Stand Alone. Stand 
;    Alone requires that only one overall routine is defined, must be called "_wd_post_main". 
;    Any subroutines defined in this file MUST be defined internal to this main routine.
; ** 29-Jun-01 NEHolt N8 Solutions, Inc / VIA Development. Created 
;    as sample post-process util
; ---------  T E R M P L A N . L S P  -----------------------------
;
; This routine is called from AutoCAD Electrical's "User post" button on the
; Terminal plan report dialog display. Report data is passed to this
; routine in AutoLISP variable called "wd_rdata". This utility can
; then operate on this report data, reformat it into a new list of
; report data "rtrn" and then pass it back to AutoCAD Electrical's report dialog 
; through a call to (c:wd_rtrn_2wd rtrn) shown at the end of this file.
;

(defun _wd_post_main ( / rtrn dclnam dcl_id user_1 user_2 user_3 cancel xx wlay1
                         wlay2 wlay3 wlay4 lay_map_lst data wd_make_dcl wd_nth_subst param_lst)
  ; -- internal subroutines

  ; --
  (defun wd_nth_subst ( n val lst / newlst ix slen x )
    ; Substitute the nth member of a list "lst" with new value "val"
    ; If "n" is past end of existing list then blank positions "nil" padded
    (if (not lst)
      (setq slen 0)
      (setq slen (length lst))
    )
    (cond
      ((minusp n)  ) ; rtrn orig list if pos is neg number
      ((zerop n) (setq lst (cons val (cdr lst)))) ; n=0, replace 1st item
      ((= n slen) (setq lst (append lst (list val)))) ; new last item
      ((< n slen) ; Insert item somewhere else in list
        (setq ix 0)
        (setq newlst '())
        (foreach x lst
          (if (/= ix n)
            (setq newlst (cons x newlst)) ; reuse existing
            (setq newlst (cons val newlst)) ; substitute new
          )
          (setq ix (1+ ix))
        )
        (setq lst (reverse newlst))
        (setq newlst nil)
      )
      ((> n slen) ; lengthen list, add "nil" pads as req'd
        (setq lst (reverse lst))
        (while (< slen n)
          (setq lst (cons nil lst))  ; add pads
          (setq slen (1+ slen))
        )
        (setq lst (reverse (cons val lst))) ; tack new item on end
    ) )
   lst
  )                         
  ; -- main routine --
  (setq rtrn nil)
  ; AutoCAD Electrical passes the report displayed data as a list of lists of lists in variable
  ; called wd_rdata. The first element of this list is the list of lists
  ; report data. The 2nd element is future (at this time).
  (if (AND wd_rdata (car wd_rdata) (listp (car wd_rdata)))
    (setq wd_rdata (car wd_rdata))) ; just go with first list of lists (report data)

  (setq user_1 "1") ; default to 1st user entry toggled on  
  ; Look for dcl file of same name, open if found.
  (setq cancel nil)
  ; see if running as pre-process or auto report. won't work for those below that require selection from dialog
  (if GBL_wd_postprocess
    (progn
      (if (listp GBL_wd_postprocess)
        (progn
          (if (> (length GBL_wd_postprocess) 1)
            (setq param_lst (cadr GBL_wd_postprocess)) ; optional for any selections within this function. none defined yet
            (setq param_lst nil)
          )
          (setq GBL_wd_postprocess (car GBL_wd_postprocess)) ; should be which one to run  
      ) )    
      (if (= (type GBL_wd_postprocess) 'INT) (setq GBL_wd_postprocess (itoa GBL_wd_postprocess)))
      (cond
        ((= GBL_wd_postprocess "1") (setq user_1 "1")) 
        ((= GBL_wd_postprocess "2") (setq user_2 "1")) 
        ((= GBL_wd_postprocess "3") (setq user_3 "1"))
        (T (setq cancel 1)) ; not a valid value
      )
  ) )      
  ; Look for dcl file of same name, open if found.
  (if (AND (not GBL_wd_postprocess) ; otherwise bypass dialog
      (setq dclnam (c:ace_find_file "termplan.dcl" 16))) ; 16=display error dialog if file not found
    (progn
      (setq dcl_id (load_dialog dclnam))                
      (if (new_dialog "main_select" dcl_id)
        (progn
          (set_tile "user1" user_1) ; preset toggle ON
          (action_tile "user1" "(setq user_1 $value)")
          (action_tile "user2" "(setq user_2 $value)")
          (action_tile "user3" "(setq user_3 $value)")
          (action_tile "cancel" "(setq cancel 1)")
          (start_dialog)
          (unload_dialog dcl_id)
  ) ) ) )

  (if (AND wd_rdata (not cancel))
    (progn ; user didn't cancel out of dialog, okay to continue  
      (if (= user_1 "1") ; Do substitution of color/gauge labels for layer names
        (progn
          ; Read current Wire layer mapping file (".wdw" file)
          (setq x (c:wd_find_wdw))
; ** 28-Apr-04.sn LeeH
;;          (if (/= x nil)(princ (strcat "\n"
;;                                       ;|termplan_dcl_009|;"Reading wdw: "
;;                                       x)))
          (if (/= x nil)(princ (strcat "\n" (c:wd_msg "WLAY029" nil "Reading wdw") ": " x)))
; ** 28-Apr-04.en
          (setq lay_map_lst (c:wd_read_wdw x))
          (if (not lay_map_lst)
; ** 28-Apr-04.sn LeeH
;;            (progn ; ".wdw" mapping file not found
;;              (princ (strcat "\n \".WDW\" "
;;                             ;|termplan_dcl_010|;"mapping file not found")
;;            ) )
              (princ (strcat "\n \".WDW\"" (c:wd_msg "WLAY030" nil "mapping file not found")))
; ** 28-Apr-04.en
          ; ELSE
            (progn ; found it, continue processing the report data
              ; WIREFRM2 report data has wire layer fields as 5th,9th,15th,19th elements of each
              ; sublist in the report data (0th element = first element in sublist)        
    
              ; Now process each sublist in the report data list (i.e. each line of report data)  
              (foreach xx wd_rdata
                (setq wlay1 (nth 4 xx)) ; existing report wire layer name "WLAY1"
                (setq wlay2 (nth 8 xx)) ; existing report wire layer name "WLAY2" 
                (setq wlay3 (nth 14 xx))
                (setq wlay4 (nth 18 xx))
                ; Now look through mapping list and try to find a match on the layer name
                (foreach data lay_map_lst
                  (if (= wlay1 (nth 0 data))
                    ; Match found, grab new substitute text string to use
                    (setq wlay1 (nth 1 data)))
                  ; Check the other layer entry  
                  (if (= wlay2 (nth 0 data))
                    ; Match found
                    (setq wlay2 (nth 1 data)))
                  (if (= wlay3 (nth 0 data))
                    ; Match found
                    (setq wlay3 (nth 1 data)))
                  (if (= wlay4 (nth 0 data))
                    ; Match found
                    (setq wlay4 (nth 1 data)))                                        
                )     
                ; Now check to see if match found for any wirelay entry. If so, substitute new
                ; value into the sublist
                (if (/= wlay1 (nth 4 xx)) 
                  (progn ; Yes, WLAY1 value needs to be updated
                    (setq xx (wd_nth_subst 4 wlay1 xx))
                  )
                )
                (if (/= wlay2 (nth 8 xx))
                  (progn ; Yes, WLAY2 value needs to be updated
                    (setq xx (wd_nth_subst 8 wlay2 xx))
                  )
                )
                (if (/= wlay3 (nth 14 xx)) 
                  (progn ; Yes, value needs to be updated
                    (setq xx (wd_nth_subst 14 wlay3 xx))
                  )
                )
                (if (/= wlay4 (nth 18 xx))
                  (progn ; Yes, value needs to be updated
                    (setq xx (wd_nth_subst 18 wlay4 xx))
                  )
                )                
                ; Now added the sublist back into the new version of the list
                (setq rtrn (cons xx rtrn))
              )
              ; The new list will be reversed from original. Flip back.
              (setq rtrn (reverse rtrn)) 
            )       
        ) )
      )    
      (if (= user_2 "1")
        (progn
          (princ
; ** 28-Apr-04.sn LeeH
;;            (strcat "\n "
;;                    ;|termplan_dcl_011|;"Nothing defined for user2 option (see termplan.lsp)")
            (strcat "\n " (c:wd_msg "WLAY031" (list "2" "termplan.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
      (if (= user_3 "1")
        (progn
          (princ
;;            (strcat "\n "
;;                    ;|termplan_dcl_012|;"Nothing defined for user3 option (see termplan.lsp)")
            (strcat "\n " (c:wd_msg "WLAY031" (list "3" "termplan.lsp") "Nothing defined for user%1 option (see %2)"))
; ** 28-Apr-04.en
      ) ) )
    )  
  )  
  (c:wd_rtrn_2wd rtrn) ; return post-processed list back to AutoCAD Electrical's report dialog
)

; -- the following AUTO-STARTS when this file is "loaded" from within AutoCAD Electrical (i.e.
;    user hits the "User post" button on a report display dialog)
(_wd_post_main) ; run the above program
(princ)
